use strict;
use warnings;
use Data::Dumper;
use Cwd;
use Getopt::Long;
use feature "state";

my $gnuplot = 'C:\Program Files (x86)\gnuplot\bin\gnuplot';


######################################################################
# 
# Script to generate Generate a summary pivot file
#
######################################################################
my %pivot;
my $debug;
my $common = "PIVOT.csv";

my $result = GetOptions ( "common=s"   => \$common,
			  "debug"      => \$debug);                       # Turn on messages



# Read the raw data file
my $ofi = 0;
my $gpu;
my $game;

my $indir = '.';

#printf ("Working on $indir\n");
opendir(IMD, $indir) || die("Cannot open directory");
my @games= readdir(IMD);

foreach my $g (@games) {
    next unless -d $g;
    unless ( ($g eq ".") || ($g eq "..") ) {
	printf ("$g\n");

	opendir(GD, $g) || die("Cannot open directory");
	my @gpus = readdir(GD);
	closedir GD;
	
	foreach my $gpu (@gpus) {

	    next if ( ($gpu eq ".") || ($gpu eq ".."));
	    next unless -d "$g\\$gpu";
	    printf ("    GPU -> $gpu\n");

	    opendir(FD, "$g\\$gpu") || die("Cannot open directory");
	    my @fs = readdir(FD);
	    closedir FD;
	    

	    # Look for a sum file
	    my $found = 0;
	    my $f = "-";
	    foreach $f (@fs) {
		if ($f =~ /sum$/) {
		    parse_sumf ($g, $gpu, "", "$g\\$gpu\\$f");
		    $found = 1;
		} 
		
		# Look for an extra dir level
		next if ( ($f eq ".") || ($f eq ".."));
		next unless -d "$g\\$gpu\\$f";
		
		printf ("        Extra -> $f\n");
		
		opendir(ED, "$g\\$gpu\\$f") || die("Cannot open directory");
		my @efs = readdir(ED);
		closedir ED;
		
		foreach my $ef (@efs) {
		    if ($ef =~ /sum$/) {
			parse_sumf ($g, $gpu, $f, "$g\\$gpu\\$f\\$ef");
			$found = 1;
		    } 
		}
	    }
	    
	    unless ($found ne 0) {
		printf ("         - Missing \.sum file\n");
		next;
	    }
	}	    
    }
}

# Print the Pivot
open OF, "> $common" or die;
printf OF ("GAME, GPU, EXTRA, OFPS, NFPS, FRAMES, RUNTS, DROPS, OF, TT, 99per, 95per, SRC\n");
foreach my $g (sort keys %pivot) {
    foreach my $gpu (sort keys %{$pivot{$g}}) {
	foreach my $e (sort keys %{$pivot{$g}{$gpu}}) {
	    printf OF ("$g, ");
	    printf OF ("$gpu, ");
	    printf OF ("$e, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{OFPS}, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{NFPS}, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{FRAMES}, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{RUNTS}, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{DROPS}, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{OF}, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{TT}, ");
	    
	    printf OF ("$pivot{$g}{$gpu}{$e}{99}, ");
	    printf OF ("$pivot{$g}{$gpu}{$e}{95}, ");
	    
	    
	    printf OF ("$pivot{$g}{$gpu}{$e}{SRC}\n");
	}
    }
}

close OF;

sub parse_sumf {
    my ($g, $gpu, $e, $sumf) = @_;
    
#    printf ("Looking for $sumf\n");

    # Open up the sum file
    my $r = open (SF, "$sumf");
    
    if ($r == 0) {
	printf ("Lost my mind....Can't open $sumf\n");
    } else {
	my @file = <SF>;
	close SF;
	
	# Parse stuff
	$file[0] =~ / - (.*)/;
	my $src = $1;
	
	$file[1] =~ /.*FPS - ([\d\.]*).*FPS ([\d\.]*)/;
	my $nfps = $1;
	my $ofps = $2;
	
	$file[2] =~ /.*\:\s*(\d+) .* (\d+) .* (\d+)/;
	my $frames = $1;
	my $runts = $2;
	my $drops = $3;
	
	$file[3] =~ /FRAPS\)\:\s*(\d+).*\:\s*(\d+)/;
	my $oframes = $1;
	my $tt = $2;
	
	# Save it
	$pivot{$g}{$gpu}{$e}{SRC} = $src;
	$pivot{$g}{$gpu}{$e}{OFPS} = $ofps;
	$pivot{$g}{$gpu}{$e}{NFPS} = $nfps;
	$pivot{$g}{$gpu}{$e}{FRAMES} = $frames;
	$pivot{$g}{$gpu}{$e}{RUNTS} = $runts;
	$pivot{$g}{$gpu}{$e}{DROPS} = $drops;
	$pivot{$g}{$gpu}{$e}{OF} = $oframes;
	$pivot{$g}{$gpu}{$e}{TT} = $tt;
	
	# get percentiles
	my $rc = open PF, "<$g\\$gpu\\$e\\percentile";
	unless ($rc) {
	    printf ("No percentile file for $g $gpu\n");
	    next;
	}
	
	@file = <PF>;
	close PF;
	
	$file[98] =~ /(\d+),.* ([\d\.]+)/;
	$pivot{$g}{$gpu}{$e}{99} = $2;
	
	$file[94] =~ /(\d+),.* ([\d\.]+)/;
	$pivot{$g}{$gpu}{$e}{95} = $2;
    }
}
