unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ComCtrls;

type
  TMain = class(TForm)
    GroupBox1: TGroupBox;
    Image: TImage;
    Panel1: TPanel;
    GoButton: TBitBtn;
    CloseButton: TBitBtn;
    Panel2: TPanel;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    ActionLog: TMemo;
    ErrorLog: TMemo;
    ProgressBar: TProgressBar;
    procedure GoButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

uses Unit2;

{$R *.DFM}

const
 WorkDir  : string = ('C:\Temp\Graphs\');

type
 SongType     = (Garbage,Offspring);
 EncoderType  = (Blade,MP3Prod,MP3Enc,mpegEnc,CD);
 BitRateType  = (_128,_160,_192,_224,_256,_320);
 SideType     = (_left,_right,_mid);
 ScaleType    = (lin,log);

const
 InSeparator  : char = '-';
 OutSeparator : char = '-';
 SongNameIn   : array [SongType] of string =
                ('Dog_New_Tricks','Gone_Away');
 SongNameOut  : array [SongType] of string =
                ('Dog New Tricks - Garbage','Gone Away - Offspring');
 EncoderNameIn: array [EncoderType] of string =
                ('Blade','MP3Prod','MP3Enc','mpegEnc','CD');
 EncoderNameOut:array [EncoderType] of string =
                ('Blade Encoder','MP3 Producer','MP3 Encoder','mpeg Encoder','original CD');
 BitRateNameIn : array [BitRateType] of string =
                ('128','160','192','224','256','320');
 BitRateNameOut: array [BitRateType] of string =
                ('128','160','192','224','256','320');
 SideNameIn   : array [SideType] of string =
                ('left','right','mid');
 SideNameOut  : array [SideType] of string =
                ('left','right','center');
 ScaleNameIn  : array [ScaleType] of string =
                ('lin','log');
 ScaleNameOut  : array [ScaleType] of string =
                ('linear','logarithmic');

type
 AFGdataType   = array [1..800] of double;

procedure TMain.GoButtonClick(Sender: TObject);
var x,y      : word;
    Song     : SongType;
    Encoder  : EncoderType;
    BitRate  : BitRateType;
    Side     : SideType;
    Scale    : ScaleType;
    BitMap,OutBitMap,OutChanBitMap,DifBitMap,DifChanBitMap
             : TBitmap;
    Breaked  : boolean;
    OriginalAFG,MP3AFG,DifAFG : array[SideType,ScaleType]of AFGdataType;
    FileName : string;
    Rect     : TRect;
    LineColor: TColor;
    YScale   : Double;
    Dots     : word;
    StartDot,EndDot : word;
    InsideLine : boolean;
    Point,TopLeftCorner
             : TPoint;

begin

 BitMap:=TBitMap.Create;
 OutBitMap:=TBitMap.Create;
 OutChanBitMap:=TBitMap.Create;
 DifBitMap:=TBitMap.Create;
 DifChanBitMap:=TBitMap.Create;

 if not SetCurrentDir(WorkDir) then ErrorLog.Lines.Add('Cannot change working directory to '+WorkDir);

 for Song := Garbage to Offspring do begin
//-----------------------------------------
// Read original CD AFGs
  for Scale := lin to log do begin
   for Side := _left to _mid do begin

    FileName := SongNameIn[Song]       + InSeparator +
                EncoderNameIn[CD]      + InSeparator +
                SideNameIn[Side]       + InSeparator +
                ScaleNameIn[Scale]     + '.bmp';
    if FileSearch(FileName,'.') = '' then
     ErrorLog.Lines.Add('File not found: '+FileName);
    ActionLog.Lines.Add('Opening file: '+FileName);
    BitMap.LoadFromFile(FileName);
    Rect.Left   := 0;
    Rect.Top    := 0;
    Rect.Right  := BitMap.Width  div 2;
    Rect.Bottom := BitMap.Height div 2;

    Image.Canvas.CopyMode := cmSrcCopy;
    Image.Canvas.StretchDraw(Rect,BitMap);
    Image.Refresh;

// scanning image for line color
    LineColor := clBlack;
    While LineColor = clBlack do begin
     for y := 0 to BitMap.Height - 1 do begin
      if BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clFuchsia
       then LineColor := clFuchsia;
      if BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clAqua
       then LineColor := clAqua;
     end;//for y := 0 to BitMap.Height - 1 do begin
    end;//While LineColor = clBlack do begin
//scanning for rectangle with AFG
    x := 0;
    for y := 0 to BitMap.Height - 1 do begin
     if (BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clGray)
      or (BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = $7F7F7F)
      then Inc(x);
     if x = 4 then begin
      Rect.Top := y;
      Break;
     end;
    end;//for y := 0 to BitMap.Height - 1 do begin
    for y := 495 downto 0 do begin
     if BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clWhite
      then begin
      Rect.Bottom := y - 1;
      Break;
     end;
    end;//for y := 495 downto 0 do begin
    for x := 0 to BitMap.Width -1 do begin
     if (BitMap.Canvas.Pixels[x , BitMap.Height div 2] = clGray)
      or (BitMap.Canvas.Pixels[x , BitMap.Height div 2] = $7F7F7F)
      then begin
       Rect.Left := x + 2;
       Break;
     end;
    end;//for x := 0 to BitMap.Width -1 do begin
    for x := BitMap.Width -1 downto 0 do begin
     if BitMap.Canvas.Pixels[x , BitMap.Height div 2] = clWhite
      then begin
      Rect.Right := x - 2;
      Break;
     end;
    end;//for x := BitMap.Width -1 downto 0 do begin

    TopLeftCorner.x := Rect.Left;
    TopLeftCorner.y := Rect.Top;
    YScale := (-120 - (-12)) / (Rect.Bottom - Rect.Top + 1);
    Dots := Rect.Right - Rect.Left + 1;


    ProgressBar.Max := Dots;
    ProgressBar.Position := 0;
    ProgressBar.Step := 1;
    for x := 1 to Dots do begin
     InsideLine := false;
     ProgressBar.StepIt;
     ProgressBar.Update;
     for y := Rect.Top to Rect.Bottom do begin
      if InsideLine then begin
       if BitMap.Canvas.Pixels[Rect.Left + x - 1 , y] <> LineColor
       then begin
        EndDot := y - 1 - Rect.Top + 1;
        Break;
       end;
      end
      else begin
       if BitMap.Canvas.Pixels[Rect.Left + x - 1 , y] = LineColor
       then begin
        StartDot := y - Rect.Top + 1;
        InsideLine := true;
       end;
      end;
     end;//for y := Rect.Top to Rect.Bottom do begin

     OriginalAFG[Side,Scale][x] := -12 + YScale * (StartDot + EndDot) / 2;

    end;//for x := 1 to Dots do begin

    ActionLog.Lines.Add('Generating output files...');

    OutBitmap.PixelFormat := pf4bit;
    OutBitMap.Width := 790;
    OutBitMap.Height := 440;
    OutChanBitmap.PixelFormat := pf4bit;
    OutChanBitMap.Width := 790;
    OutChanBitMap.Height := 440;
    Rect.Left := 0;
    Rect.Top := 0;
    Rect.Right := 790;
    Rect.Bottom := 440;
    OutBitMap.Canvas.Brush.Color := clSilver;
    OutBitMap.Canvas.Font.Color := clBlack;
    OutBitMap.Canvas.Font.Name := 'Arial';
    OutBitMap.Canvas.Font.Height := -20;
    OutBitMap.Canvas.Font.Style := [fsBold];
    OutBitMap.Canvas.FillRect(Rect);
    FileName := SongNameOut[Song] + '        ' + EncoderNameOut[CD];
    OutBitMap.Canvas.TextOut(
          395 - (OutBitMap.Canvas.TextWidth(FileName)  div 2),
           20 - (OutBitMap.Canvas.TextHeight(FileName) div 2),
          FileName);
    OutBitMap.Canvas.Pen.Color := clGray;
    if Scale = lin then EndDot:=0
                   else EndDot:=0;
    Point.x := 4 + EndDot;
    Point.y := 424;
    OutBitMap.Canvas.PenPos := Point;
    Point.y := 41;
    OutBitMap.Canvas.LineTo(Point.x,Point.y);
    Point.x := 768 - EndDot;
    OutBitMap.Canvas.LineTo(Point.x,Point.y);
    OutBitMap.Canvas.Pen.Color := clWhite;
    Point.y := 424;
    OutBitMap.Canvas.LineTo(Point.x,Point.y);
    Point.x := 4 + EndDot;
    OutBitMap.Canvas.LineTo(Point.x,Point.y);

    ProgressBar.Max := Dots + 25 -  EndDot * 2;
    ProgressBar.Position := 0;
    ProgressBar.Step := 1;
    StartDot := 1 + EndDot * 2;
    for x := StartDot to Dots + 25 do begin
     ProgressBar.StepIt;
     ProgressBar.Update;
     for y := 1 to 382 + 25 do
      if BitMap.Canvas.Pixels[x + TopLeftCorner.x -1 ,
                              y + TopLeftCorner.y -1] = LineColor
      then begin
       case Side of
        _left  : OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clAqua;
        _right : begin
                  OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clFuchsia;
                  OutChanBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clFuchsia;
                 end;
        _mid   : begin
                  OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clLime;
                  OutChanBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clLime;
                 end;
       end;//case
      end
      else OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] :=
             BitMap.Canvas.Pixels[x + TopLeftCorner.x -1 ,
                                  y + TopLeftCorner.y -1];
    end;//for x := 1 to Dots do begin
    ProgressBar.Position := 0;
    if Scale = lin then begin
     OutBitMap.Canvas.Draw(1,420,Xlam.LeftCornerLin.Picture.Bitmap);
     OutBitMap.Canvas.Draw(742,418,Xlam.RightCornerLin.Picture.Bitmap);
     OutBitMap.Canvas.Draw(763,40,Xlam.RightCorner.Picture.Bitmap);
     OutBitMap.Canvas.Draw(660,70,Xlam.Legend.Picture.Bitmap);
    end
    else begin
     OutBitMap.Canvas.Draw(0,420,Xlam.LeftCornerLog.Picture.Bitmap);
     OutBitMap.Canvas.Draw(742,418,Xlam.RightCornerLog.Picture.Bitmap);
     OutBitMap.Canvas.Draw(763,40,Xlam.RightCorner.Picture.Bitmap);
     OutBitMap.Canvas.Draw(660,70,Xlam.Legend.Picture.Bitmap);
    end;

    FileName := 'Result\'+
                SongNameIn[Song]       + OutSeparator +
                EncoderNameIn[CD]      + OutSeparator +
                ScaleNameIn[Scale]     + OutSeparator +
                SideNameIn[Side]       + '.bmp';
    ActionLog.Lines.Add('Saving file: '+FileName);

    if Side = _left then OutChanBitMap.Canvas.Draw(0,0,OutBitMap);

    Rect.Left   := 0;
    Rect.Top    := 0;
    Rect.Right  := Image.Width;
    Rect.Bottom := Image.Height;
    Image.Canvas.Brush.Color := clSilver;
    Image.Canvas.FillRect(Rect);
    Rect.Right  := OutBitMap.Width  div 2;
    Rect.Bottom := OutBitMap.Height div 2;
    Image.Canvas.StretchDraw(Rect,OutBitMap);
    Image.Refresh;

    OutBitMap.SaveToFile(FileName);

   end;//for Side := _left to _mid do begin

   FileName := 'Result\'+
                 SongNameIn[Song]       + OutSeparator +
                 EncoderNameIn[CD]      + OutSeparator +
                 ScaleNameIn[Scale]     + '.bmp';
   ActionLog.Lines.Add('Saving file: '+FileName);

   Rect.Left   := 0;
   Rect.Top    := 0;
   Rect.Right  := Image.Width;
   Rect.Bottom := Image.Height;
   Image.Canvas.Brush.Color := clSilver;
   Image.Canvas.FillRect(Rect);
   Rect.Right  := OutChanBitMap.Width  div 2;
   Rect.Bottom := OutChanBitMap.Height div 2;
   Image.Canvas.StretchDraw(Rect,OutChanBitMap);
   Image.Refresh;

   OutChanBitMap.SaveToFile(FileName);

  end;//for Scale := lin to log do begin

//----------------------------------------
// Read compressed MP3s AFGs
  for Encoder := Blade to mpegEnc do begin
   for BitRate := _128 to _320 do begin
    for Scale := lin to log do begin
     Breaked:=false;
     for Side := _left to _mid do begin
      FileName := SongNameIn[Song]       + InSeparator +
                  EncoderNameIn[Encoder] + InSeparator +
                  BitRateNameIn[BitRate] + InSeparator +
                  SideNameIn[Side]       + InSeparator +
                  ScaleNameIn[Scale]     + '.bmp';
      if FileSearch(FileName,'.') = '' then begin
       ErrorLog.Lines.Add('File not found: '+FileName);
       Breaked:=true;
       Break;
      end;//if FileSearch(FileName,'.') = '' then begin

      ActionLog.Lines.Add('Opening file: '+FileName);
      BitMap.LoadFromFile(FileName);
      Rect.Left   := 0;
      Rect.Top    := 0;
      Rect.Right  := BitMap.Width  div 2;
      Rect.Bottom := BitMap.Height div 2;

      Image.Canvas.CopyMode := cmSrcCopy;
      Image.Canvas.StretchDraw(Rect,BitMap);
      Image.Refresh;

// scanning image for line color
      LineColor := clBlack;
      While LineColor = clBlack do begin
       for y := 0 to BitMap.Height - 1 do begin
        if BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clFuchsia
         then LineColor := clFuchsia;
        if BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clAqua
         then LineColor := clAqua;
       end;//for y := 0 to BitMap.Height - 1 do begin
      end;//While LineColor = clBlack do begin
//scanning for rectangle with AFG
      x := 0;
      for y := 20 to BitMap.Height - 1 do begin
       if (BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clGray)
        or (BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = $7F7F7F)
        then Inc(x);
       if x = 4 then begin
        Rect.Top := y;
        Break;
       end;
      end;//for y := 0 to BitMap.Height - 1 do begin
      for y := 495 downto 0 do begin
       if BitMap.Canvas.Pixels[BitMap.Width  div 2 , y] = clWhite
        then begin
        Rect.Bottom := y - 1;
        Break;
       end;
      end;//for y := 495 downto 0 do begin
      for x := 0 to BitMap.Width -1 do begin
       if BitMap.Canvas.Pixels[x , BitMap.Height div 2] and $FFFFFF = clBlack
        then begin
         Rect.Left := x + 1;
         Break;
       end;
      end;//for x := 0 to BitMap.Width -1 do begin
      for x := BitMap.Width -1 downto 0 do begin
       if BitMap.Canvas.Pixels[x , BitMap.Height div 2] = clWhite
        then begin
        Rect.Right := x - 2;
        Break;
       end;
      end;//for x := BitMap.Width -1 downto 0 do begin

      TopLeftCorner.x := Rect.Left;
      TopLeftCorner.y := Rect.Top;
      YScale := (-120 - (-12)) / (Rect.Bottom - Rect.Top + 1);
      Dots := Rect.Right - Rect.Left + 1;


      ProgressBar.Max := Dots;
      ProgressBar.Position := 0;
      ProgressBar.Step := 1;
      for x := 1 to Dots do begin
       InsideLine := false;
       ProgressBar.StepIt;
       ProgressBar.Update;
       for y := Rect.Top to Rect.Bottom do begin
        if InsideLine then begin
         if BitMap.Canvas.Pixels[Rect.Left + x - 1 , y] <> LineColor
         then begin
          EndDot := y - 1 - Rect.Top + 1;
          Break;
         end;
        end
        else begin
         if BitMap.Canvas.Pixels[Rect.Left + x - 1 , y] = LineColor
         then begin
          StartDot := y - Rect.Top + 1;
          InsideLine := true;
         end;
        end;
       end;//for y := Rect.Top to Rect.Bottom do begin

       MP3AFG[Side,Scale][x] := -12 + YScale * (StartDot + EndDot) / 2;
       DifAFG[Side,Scale][x] := MP3AFG[Side,Scale][x] - OriginalAFG[Side,Scale][x]

      end;//for x := 1 to Dots do begin


      ActionLog.Lines.Add('Generating output files...');

      OutBitmap.PixelFormat := pf4bit;
      OutBitMap.Width := 790;
      OutBitMap.Height := 440;
      OutChanBitmap.PixelFormat := pf4bit;
      OutChanBitMap.Width := 790;
      OutChanBitMap.Height := 440;
      DifBitmap.PixelFormat := pf4bit;
      DifBitMap.Width := 790;
      DifBitMap.Height := 440;
      if Scale = lin then DifBitMap.Canvas.Draw(0,0,Xlam.ScaleLin.Picture.Bitmap)
                     else DifBitMap.Canvas.Draw(0,0,Xlam.ScaleLog.Picture.Bitmap);
      DifChanBitMap.PixelFormat := pf4bit;
      DifChanBitMap.Width := 790;
      DifChanBitMap.Height := 440;
      Rect.Left := 0;
      Rect.Top := 0;
      Rect.Right := 790;
      Rect.Bottom := 440;
      OutBitMap.Canvas.Brush.Color := clSilver;
      OutBitMap.Canvas.Font.Color := clBlack;
      OutBitMap.Canvas.Font.Name := 'Arial';
      OutBitMap.Canvas.Font.Height := -20;
      OutBitMap.Canvas.Font.Style := [fsBold];
      DifBitMap.Canvas.Brush.Color := clSilver;
      DifBitMap.Canvas.Font.Color := clBlack;
      DifBitMap.Canvas.Font.Name := 'Arial';
      DifBitMap.Canvas.Font.Height := -20;
      DifBitMap.Canvas.Font.Style := [fsBold];
      OutBitMap.Canvas.FillRect(Rect);
      FileName := SongNameOut[Song]      + '        ' +
                  EncoderNameOut[Encoder] + ', ' +
                  BitRateNameOut[BitRate] + ' kbps';
      OutBitMap.Canvas.TextOut(
          395 - (OutBitMap.Canvas.TextWidth(FileName)  div 2),
           20 - (OutBitMap.Canvas.TextHeight(FileName) div 2),
          FileName);
      FileName := FileName + '        difference';
      DifBitMap.Canvas.TextOut(
          395 - (OutBitMap.Canvas.TextWidth(FileName)  div 2),
           20 - (OutBitMap.Canvas.TextHeight(FileName) div 2),
          FileName);
      OutBitMap.Canvas.Pen.Color := clGray;
      if Scale = lin then EndDot:=0
                     else EndDot:=0;
      Point.x := 4 + EndDot;
      Point.y := 424;
      OutBitMap.Canvas.PenPos := Point;
      Point.y := 41;
      OutBitMap.Canvas.LineTo(Point.x,Point.y);
      Point.x := 768 - EndDot;
      OutBitMap.Canvas.LineTo(Point.x,Point.y);
      OutBitMap.Canvas.Pen.Color := clWhite;
      Point.y := 424;
      OutBitMap.Canvas.LineTo(Point.x,Point.y);
      Point.x := 4 + EndDot;
      OutBitMap.Canvas.LineTo(Point.x,Point.y);

      ProgressBar.Max := Dots + 25 -  EndDot * 2;
      ProgressBar.Position := 0;
      ProgressBar.Step := 1;
      StartDot := 1 + EndDot * 2;
      for x := StartDot to Dots + 25 do begin
       ProgressBar.StepIt;
       ProgressBar.Update;
       for y := 1 to 382 + 25 do
        if BitMap.Canvas.Pixels[x + TopLeftCorner.x -1 ,
                                y + TopLeftCorner.y -1] = LineColor
        then begin
         case Side of
          _left  : begin
                    OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clAqua;
                    DifBitMap.Canvas.Pixels[x + 4 - EndDot ,
                        Round((DifAFG[Side,Scale][x] - 24) / YScale) + 46] := clAqua;
                   end;
          _right : begin
                    OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clFuchsia;
                    OutChanBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clFuchsia;
                    DifBitMap.Canvas.Pixels[x + 4 - EndDot ,
                        Round((DifAFG[Side,Scale][x] - 24) / YScale) + 46] := clFuchsia;
                    DifChanBitMap.Canvas.Pixels[x + 4 - EndDot ,
                        Round((DifAFG[Side,Scale][x] - 24) / YScale) + 46] := clFuchsia;
                   end;
          _mid   : begin
                    OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clLime;
                    OutChanBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] := clLime;
                    DifBitMap.Canvas.Pixels[x + 4 - EndDot ,
                        Round((DifAFG[Side,Scale][x] - 24) / YScale) + 46] := clLime;
                    DifChanBitMap.Canvas.Pixels[x + 4 - EndDot ,
                        Round((DifAFG[Side,Scale][x] - 24) / YScale) + 46] := clLime;
                   end;
         end;//case
        end
        else OutBitMap.Canvas.Pixels[x + 4 - EndDot , y + 41] :=
               BitMap.Canvas.Pixels[x + TopLeftCorner.x -1 ,
                                    y + TopLeftCorner.y -1];
      end;//for x := 1 to Dots do begin
      ProgressBar.Position := 0;
      if Scale = lin then begin
       OutBitMap.Canvas.Draw(1,420,Xlam.LeftCornerLin.Picture.Bitmap);
       OutBitMap.Canvas.Draw(742,418,Xlam.RightCornerLin.Picture.Bitmap);
       OutBitMap.Canvas.Draw(763,40,Xlam.RightCorner.Picture.Bitmap);
       OutBitMap.Canvas.Draw(660,70,Xlam.Legend.Picture.Bitmap);
      end
      else begin
       OutBitMap.Canvas.Draw(0,420,Xlam.LeftCornerLog.Picture.Bitmap);
       OutBitMap.Canvas.Draw(742,418,Xlam.RightCornerLog.Picture.Bitmap);
       OutBitMap.Canvas.Draw(763,40,Xlam.RightCorner.Picture.Bitmap);
       OutBitMap.Canvas.Draw(660,70,Xlam.Legend.Picture.Bitmap);
      end;

      FileName := 'Result\'+
                  SongNameIn[Song]       + OutSeparator +
                  EncoderNameIn[Encoder] + OutSeparator +
                  BitRateNameIn[BitRate] + OutSeparator +
                  ScaleNameIn[Scale]     + OutSeparator +
                  SideNameIn[Side]       + '.bmp';
      ActionLog.Lines.Add('Saving file: '+FileName);

      if Side = _left then OutChanBitMap.Canvas.Draw(0,0,OutBitMap);
      if Side = _left then DifChanBitMap.Canvas.Draw(0,0,DifBitMap);

      Rect.Left   := 0;
      Rect.Top    := 0;
      Rect.Right  := Image.Width;
      Rect.Bottom := Image.Height;
      Image.Canvas.Brush.Color := clSilver;
      Image.Canvas.FillRect(Rect);
      Rect.Right  := OutBitMap.Width  div 2;
      Rect.Bottom := OutBitMap.Height div 2;
      Image.Canvas.StretchDraw(Rect,OutBitMap);
      Image.Refresh;

      OutBitMap.SaveToFile(FileName);

      FileName := 'Result\_'+
                  SongNameIn[Song]       + OutSeparator +
                  EncoderNameIn[Encoder] + OutSeparator +
                  BitRateNameIn[BitRate] + OutSeparator +
                  ScaleNameIn[Scale]     + OutSeparator +
                  SideNameIn[Side]       + '.bmp';
      ActionLog.Lines.Add('Saving file: '+FileName);
      DifBitMap.SaveToFile(FileName);

//      Exit;

     end;//for Side := _left to _mid do begin
     if Breaked then Break;

     FileName := 'Result\'+
                 SongNameIn[Song]       + OutSeparator +
                 EncoderNameIn[Encoder] + OutSeparator +
                 BitRateNameIn[BitRate] + OutSeparator +
                 ScaleNameIn[Scale]     + '.bmp';
     ActionLog.Lines.Add('Saving file: '+FileName);

     Rect.Left   := 0;
     Rect.Top    := 0;
     Rect.Right  := Image.Width;
     Rect.Bottom := Image.Height;
     Image.Canvas.Brush.Color := clSilver;
     Image.Canvas.FillRect(Rect);
     Rect.Right  := OutChanBitMap.Width  div 2;
     Rect.Bottom := OutChanBitMap.Height div 2;
     Image.Canvas.StretchDraw(Rect,OutChanBitMap);
     Image.Refresh;

     OutChanBitMap.SaveToFile(FileName);

     FileName := 'Result\_'+
                 SongNameIn[Song]       + OutSeparator +
                 EncoderNameIn[Encoder] + OutSeparator +
                 BitRateNameIn[BitRate] + OutSeparator +
                 ScaleNameIn[Scale]     + '.bmp';
     ActionLog.Lines.Add('Saving file: '+FileName);
     DifChanBitMap.SaveToFile(FileName);

    end;//for Scale = lin to log do begin
   end;//for BitRate := _128 to _320 do begin
  end;//for Encoder := Blade to mpegEnc do begin
 end;//for Song := Garbage to Offspring do begin

(*
 BitMap.LoadFromFile('1.bmp');
 for x := 0 to Bitmap.Width do
  for y := 0 to Bitmap.Height do
   if BitMap.Canvas.Pixels[x,y] = $00C0C0C0 then
    BitMap.Canvas.Pixels[x,y] := $00FFFFFF;
 BitMap.PixelFormat := pf4bit ;
 BitMap.SaveToFile('2.bmp');
 Image.Canvas.Draw(0,0,BitMap);
*)

 ActionLog.Lines.SaveToFile('Action.Log');
 ErrorLog.Lines.SaveToFile('Error.Log');

 DifChanBitMap.Destroy;
 DifBitMap.Destroy;
 OutChanBitMap.Destroy;
 OutBitMap.Destroy;
 BitMap.Destroy;

end;//procedure TMain.GoButtonClick(Sender: TObject);

procedure TMain.CloseButtonClick(Sender: TObject);
begin
 Close;
end;//procedure TMain.BitBtn1Click(Sender: TObject);


end.//unit Unit1;
